package org.msh.tb.bd.dashboard.query;

import org.msh.utils.date.DateUtils;

import java.util.List;

/**
 * Created by mauri on 01/06/2017.
 */
public class Indicator07Query extends IndicatorQuery {

    /**
     * This method is not being used by indicator 07 .
     * @return null
     */
    @Override
    public Float calculateRate(Object[] o) {
        return null;
    }

    /**
     * This method is not being used by indicator 07 detailed report.
     * @return null
     */
    @Override
    public List<Object[]> getDetailedResult(){
        return null;
    }

    /**
     * @return The result used by IndicatorParser to create the dashboard summarized report.
     */
    public List<Object[]> getSummaryResult(){

        String auCondition = getSelectedAdminUnit() == null ? "" : "and c.notificationUnit.adminUnit.code like  '" + getSelectedAdminUnit().getCode() + "%'";

        List<Object[]> ret = getQueryResult(auCondition);

        return ret;
    }

    @Override
    protected List<Object[]> getQueryResult(String adminUnitCondition) {
        // query indicator result
        // get population by administrative units child of auSelected
        // get new and relapses cases notified inside each of these administrative units
        List<Object[]> result = getEntityManager().createQuery(" select c.classification, max(datediff(c.treatmentPeriod.iniDate , c.registrationDate)), avg(datediff(c.treatmentPeriod.iniDate , c.registrationDate)) " +
                    "from TbCase c join c.patient p " +
                    "where c.registrationDate between :iniDate and :endDate " +
                    "and c.registrationDate <= :now and c.treatmentPeriod.iniDate <= :now " + // don't consider cases with future (wrong) date
                    "and datediff(c.treatmentPeriod.iniDate , c.registrationDate) >= 0 " +
                    adminUnitCondition + " and p.workspace.id = :wsId " +
                    "group by c.classification " +
                    "order by c.classification")
                .setParameter("iniDate", getIniDate())
                .setParameter("endDate", getEndDate())
                .setParameter("now", DateUtils.getDate())
                .setParameter("wsId", getWorkspace().getId())
                .getResultList();

        return result;
    }

}
